package libsidutils;

import java.io.IOException;
import java.util.StringTokenizer;

public class SidDatabase {
	private static final String ERR_DATABASE_CORRUPT = "SID DATABASE ERROR: Database seems to be corrupt.";;
	private static final String ERR_NO_DATABASE_LOADED = "SID DATABASE ERROR: Songlength database not loaded.";
	private static final String ERR_NO_SELECTED_SONG = "SID DATABASE ERROR: No song selected for retrieving song length.";
	private static final String ERR_UNABLE_TO_LOAD_DATABASE = "SID DATABASE ERROR: Unable to load the songlegnth database.";

	private IniReader database;
	private String errorString;

	private int /* int_least32_t */parseTimeStamp(final String arg) {
		/*
		 * Read in m:s format at most. Could use a system function if available.
		 */
		int /* int_least32_t */seconds = 0;
		int passes = 2; // minutes, seconds
		boolean gotDigits = false;
		int argPos = 0;
		while (passes-- > 0) {
			if (Character.isDigit(arg.charAt(argPos))) {
				String sub = arg.substring(argPos);
				int t;
				int indexOf = sub.indexOf(':');
				if (indexOf != -1) {
					t = Integer.parseInt(sub.substring(0, indexOf));
				} else {
					indexOf = sub.indexOf('(');
					if (indexOf != -1) {
						t = Integer.parseInt(sub.substring(0, indexOf));
					} else {
						t = Integer.parseInt(sub);
					}
				}
				seconds += t;
				gotDigits = true;
			}
			while (argPos < arg.length()
					&& Character.isDigit(arg.charAt(argPos))) {
				++argPos;
			}
			if (argPos < arg.length() && arg.charAt(argPos) == ':') {
				seconds *= 60;
				++argPos;
			}
		}

		// Handle -:-- time stamps and old 0:00 entries which
		// need to be rounded up by one second.
		if (!gotDigits)
			seconds = 0;
		else if (seconds == 0)
			++seconds;

		return seconds;
	}

	private short /* uint_least8_t */timesFound(String str) {
		/*
		 * Try and determine the number of times read back. Used to check
		 * validility of times in database.
		 */
		short /* uint_least8_t */count = 0;
		int strPos = 0;
		while (strPos < str.length()) {
			if (str.charAt(strPos++) == ':')
				count++;
		}
		return count;
	}

	public SidDatabase() {
		database = (null);
	}

	public int open(final String filename) {
		close();
		try {
			database = new IniReader(filename);
		} catch (IOException e) {
			errorString = ERR_UNABLE_TO_LOAD_DATABASE;
			return -1;
		}

		return 0;
	}

	public void close() {
	}

	public int /* int_least32_t */length(SidTuneMod tune) {
		StringBuffer md5 = new StringBuffer();
		int /* uint_least16_t */song = tune.getInfo().currentSong;
		if (song == 0) {
			errorString = ERR_NO_SELECTED_SONG;
			return -1;
		}
		tune.createMD5(md5);
		return length(md5.toString(), song);
	}

	public int /* int_least32_t */length(final String md5,
			int /* uint_least16_t */song) {
		int /* int_least32_t */time = 0;
		String timeStamp = null;

		if (database == null) {
			errorString = ERR_NO_DATABASE_LOADED;
			return -1;
		}

		// Read Time (and check times before hand)
		String value = database.getPropertyString("Database", md5, null);
		// If value return is null then no entry found in database
		if (value != null) {
			StringTokenizer st = new StringTokenizer(value, " ", false);
			for (int /* uint_least16_t */i = 0; i < song; i++) {
				if (!st.hasMoreTokens()) { // No time found
					errorString = ERR_DATABASE_CORRUPT;
					return -1;
				}
				timeStamp = st.nextToken();
				// Validate Time
				if (timesFound(timeStamp) != 1) {
					errorString = ERR_DATABASE_CORRUPT;
					return -1;
				}
			}

			// Parse time stamp
			time = parseTimeStamp(timeStamp);
		}

		return time;
	}

	public final String error() {
		return errorString;
	}
}
